﻿using System;
using Soneta.Ksiega;
using Soneta.SrodkiTrwale;
using Soneta.Types;

namespace ASP
{
    public partial class EwidencjaSrodkowTrwalych : System.Web.UI.Page
    {
        public static string Str_ExcBrakOkresuObrachunkowego = "Brak okresu obrachunkowego dla daty aktualności {0}.";

        private WartosciSrodkaWorker worker = new WartosciSrodkaWorker();
        private SrodkiTrwale.Params parameters;

        protected void dc_ContextLoad(object sender, EventArgs e)
        {
            parameters = (SrodkiTrwale.Params)dc.Context[typeof(SrodkiTrwale.Params)];
        }

        protected void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args)
        {
            SrodekTrwalyBaseHistoria sHistoria = (SrodekTrwalyBaseHistoria)args.Row;

            if (sHistoria.Srodek.Stan == StanSrodkaTrwalego.Wpisany)
            {
                args.VisibleRow = false;
                return;
            }

            if (sHistoria.Srodek.DataRejestracji > parameters.Aktualnosc)
            {
                args.VisibleRow = false;
                return;
            }

            if (!sHistoria.Srodek.DataLikwidacji.IsNull && sHistoria.Srodek.DataLikwidacji <= parameters.Aktualnosc)
            {
                DataLikwidacji.EditValue = sHistoria.Srodek.DataLikwidacji;

                if (!sHistoria.Srodek.ZbycieData.IsNull && sHistoria.Srodek.ZbycieData <= parameters.Aktualnosc)
                    PrzyczynaZbycia.EditValue = sHistoria.Srodek.ZbycieData + (sHistoria.Srodek.LT != null ? " / " + sHistoria.Srodek.LT.Tytul.Tytul : String.Empty);
            }
            else
            {
                DataLikwidacji.EditValue = String.Empty;
                PrzyczynaZbycia.EditValue = String.Empty;
            }

            worker.SrodekHistoria = sHistoria;
            worker.Data = parameters.Aktualnosc;

            ZmianaWartosciB.EditValue = worker.WartoscBilansowa - worker.WartoscPoczatkowaBilansowa;
            ZmianaWartosciP.EditValue = worker.WartoscPodatkowa - worker.WartoscPoczatkowaPodatkowa;

            //
            // amortyzacja na rok
            //

            FromTo okresObrachunkowy;
            if (sHistoria.Module.Config.Ogólne.UwzględniajKontekstOkresuObrach)
            {
                OkresObrachunkowy okres = KsiegaModule.GetInstance(sHistoria).OkresyObrach[parameters.Aktualnosc];
                if (okres == null)
                    throw new ApplicationException(String.Format(Str_ExcBrakOkresuObrachunkowego, parameters.Aktualnosc));
                okresObrachunkowy = okres.Okres;
            }
            else
                okresObrachunkowy = FromTo.Year(parameters.Aktualnosc);

            Currency wartoscBilansowa = Currency.Zero;
            Currency wartoscPodatkowa = Currency.Zero;

            Plan plan = new Plan(sHistoria.Srodek, parameters.Aktualnosc);

            foreach (Plan.PlanItem item in plan.Items)
                if (okresObrachunkowy.Contains(item.Okres))
                {
                    wartoscBilansowa += item.WartoscBilansowa;
                    wartoscPodatkowa += item.WartoscPodatkowa;
                }

            PlanB.EditValue = wartoscBilansowa;
            PlanP.EditValue = wartoscPodatkowa;
        }
    }
}
